(function($) {

  $.fn.menumaker = function(options) {
      
      var fylevym = $(this), settings = $.extend({
        title: "Menu",
        format: "dropdown",
        sticky: false
      }, options);

      return this.each(function() {
        fylevym.prepend('<div id="menu-button">' + settings.title + '</div>');
        $(this).find("#menu-button").on('click', function(){
          $(this).toggleClass('menu-opened');
          var tizofotefij = $(this).next('ul');
          if (tizofotefij.hasClass('open')) { 
            tizofotefij.hide().removeClass('open');
          }
          else {
            tizofotefij.show().addClass('open');
            if (settings.format === "dropdown") {
              tizofotefij.find('ul').show();
            }
          }
        });

        fylevym.find('li ul').parent().addClass('has-sub');

        multiTg = function() {
          fylevym.find(".has-sub").prepend('<span class="submenu-button"></span>');
          fylevym.find('.submenu-button').on('click', function() {
            $(this).toggleClass('submenu-opened');
            if ($(this).siblings('ul').hasClass('open')) {
              $(this).siblings('ul').removeClass('open').hide();
            }
            else {
              $(this).siblings('ul').addClass('open').show();
            }
          });
        };

        if (settings.format === 'multitoggle') multiTg();
        else fylevym.addClass('dropdown');

        if (settings.sticky === true) fylevym.css('position', 'fixed');

        resizeFix = function() {
          if ($( window ).width() > 768) {
            fylevym.find('ul').show();
          }

          if ($(window).width() <= 768) {
            fylevym.find('ul').hide().removeClass('open');
          }
        };
        resizeFix();
        return $(window).on('resize', resizeFix);

      });
  };
})(jQuery);

(function($){
$(document).ready(function(){

$("#cijik").menumaker({
   title: "Menu",
   format: "multitoggle"
});

});
})(jQuery);