function setupResetPassword(){
    
let USER_MOBILE_NUM,USER_PASSWORD="",USER_INPUT_OTP="",USER_CONFIRM_PASSWORD="",USER_OTP="",OTP_TIME_OUT = 0;
let input_mobile_num = document.querySelector("#forget-input-mobile-num");
let input_otp = document.querySelector("#forget-input-otp");
let send_otp_btn = document.querySelector(".forget-send-otp-btn");
let reset_password_btn = document.querySelector(".reset-password-btn");
let extra_msg_view = document.querySelector(".extra-msg-view");

let input_password = document.querySelector("#forget-input-new-password");
let input_confirm_password = document.querySelector("#forget-input-confirm-password");

input_mobile_num.addEventListener('input', checkInput);
const DEFAULT_VALUE = input_mobile_num.value;

function checkInput(e) {
  const currentInput = this.value;
  const currentInputDefaultPart = currentInput.substring(0, DEFAULT_VALUE.length);

  // check if the default part is no longer same as DEFAULT
  if (currentInputDefaultPart !== DEFAULT_VALUE) {
    // reset
    this.value = DEFAULT_VALUE;
  }
}

function dismissExtraMsg() {
  extra_msg_view.classList.add("hide_view");
}

reset_password_btn.addEventListener("click", ()=>{
   requestPassword();
})

function requestPassword(){
   async function requestFile(mobile_num,password,entered_otp) {
       try {
         const response = 
         await fetch(apiTargetURL+"reset_password.php?USER_MOBILE="+mobile_num+
         "&USER_OTP="+entered_otp+"&NEW_PASSWORD="+password, {
           method: "GET"
         });
     
         const resp = await response.json();
         
         if(resp.status_code == "success"){
            input_password.value = "";
            input_confirm_password.value = "";
            gotoLogin();
         }else if(resp.status_code == "otp_not_matched"){
           showToast('Oops! OTP not matcheds');
         }else if(resp.status_code == "account_error"){
           showToast('Oops! Entered Mobile number not matched!');
         }else{
           showToast('Oops! Something went wrong! Please try again!');
         }

         dismissLoadingDialog();
       } catch (error) {
         dismissLoadingDialog();
       }
   }

   apiTargetURL = input_api_target.value;
   USER_INPUT_OTP = input_otp.value;
   USER_PASSWORD = input_password.value;
   USER_CONFIRM_PASSWORD = input_confirm_password.value;

   if(USER_MOBILE_NUM!="" && USER_INPUT_OTP!="" && USER_PASSWORD != "" &&
   USER_CONFIRM_PASSWORD != ""){

       if(!Number(USER_MOBILE_NUM) || USER_MOBILE_NUM.length != 10){
         showToast('Invalid Mobile Number!');
       }else if(USER_PASSWORD.length < 4){
         showToast('Oops! Password length should be atleast 4');
       }else if(USER_PASSWORD != USER_CONFIRM_PASSWORD){
         showToast('Oops! Password not matched!');
       }else if(USER_INPUT_OTP.length < 4){
         showToast('Oops! Enter correct OTP');
       }else if(apiTargetURL!=""){
         showLoadingDialog();
         requestFile(USER_MOBILE_NUM,USER_PASSWORD,USER_INPUT_OTP);
       }
   }else{
       showToast('Please fill all the input fields!');
   }
}

function showPasswordChangedMsg(){
  extra_msg_view.classList.remove("hide_view");
  setTimeout(dismissExtraMsg, 2000);
}

send_otp_btn.addEventListener("click", ()=>{
    if(OTP_TIME_OUT <= 0){
        requestOTP();
    }else{
        showToast('Oops! Please wait to send next OTP!');
    }
})

function requestOTP(){
    async function requestFile(mobile_num) {
       try {
         const response = 
         await fetch(apiTargetURL+"services/sms/send-sms.php?MOBILE="+mobile_num+"&PURPOSE=RP", {
           method: "GET"
         });
     
         const resp = await response.json();

         if(resp.status_code == "SMS sent successfully."){
           showToast('OTP sent !');
           USER_MOBILE_NUM = mobile_num;
           input_mobile_num.disabled = true;
           
           OTP_TIME_OUT = 60;
           startCountDown();
         }else{
           USER_MOBILE_NUM= "";
           showToast('Oops! Failed to send OTP!');
         }

         dismissLoadingDialog();
       } catch (error) {
         dismissLoadingDialog();
       }
   }

   USER_MOBILE_NUM = input_mobile_num.value;
   USER_MOBILE_NUM = USER_MOBILE_NUM.slice(3);
   
   if(USER_MOBILE_NUM.length == 10){
      showLoadingDialog();
      requestFile(USER_MOBILE_NUM);
   }else{
      showToast('Invalid Mobile Number!'+USER_MOBILE_NUM.length);
   }
}

function startCountDown(){
  var int_val = setInterval(function() { 
  if (OTP_TIME_OUT <= 0) {  
    clearInterval(int_val);  
    OTP_TIME_OUT = 0;
    send_otp_btn.innerHTML = "OTP";
  }else{
    OTP_TIME_OUT--;
    send_otp_btn.innerHTML = OTP_TIME_OUT+" s";
  } }, 1000);
}

}