function setupLogin(){
    
let USER_MOBILE_NUM = "",USER_PASSWORD = "", selectedProject = "PARITY";
let input_mobile_num = document.querySelector("#login-input-mobile-num");
let input_password = document.querySelector("#login-input-password");
let login_btn = document.querySelector(".login-btn");
let contents = document.querySelector(".contents");
let main_view = document.querySelector(".main-view");

input_mobile_num.addEventListener('input', checkInput);
const DEFAULT_VALUE = input_mobile_num.value;

function checkInput(e) {
  const currentInput = this.value;
  const currentInputDefaultPart = currentInput.substring(0, DEFAULT_VALUE.length);

  // check if the default part is no longer same as DEFAULT
  if (currentInputDefaultPart !== DEFAULT_VALUE) {
    // reset
    this.value = DEFAULT_VALUE;
  }
}

login_btn.addEventListener("click", () => {
    requestRecords();
})

function requestRecords() {
    async function requestFile(mobile_num, password) {
        try {
            const response =
                await fetch(apiTargetURL + "login_account.php?LOGIN_ID=" + mobile_num + "&LOGIN_PASSWORD=" + password, {
                    method: "GET"
                });

            const resp = await response.json();

            if (resp.status_code == "success") {
                let account_id = resp['data'][0]['account_id'];
                let account_balance = resp['data'][0]['account_balance'];
                let account_mobile_num = resp['data'][0]['account_mobile_num'];
                let account_refered_by = resp['data'][0]['account_refered_by'];
                let auth_secret_key = resp['data'][0]['auth_secret_key'];
                let selected_game = resp['data'][0]['account_selected_game'];
                
                localStorage.setItem("PROJECT-NAME", selectedProject);
                localStorage.setItem("USER-AUTH-SECRET", auth_secret_key);
                localStorage.setItem("USER-SESSION", account_id);
                localStorage.setItem("USER-MOBILE-NUM", account_mobile_num);
                localStorage.setItem("USER-BALANCE", account_balance);
                localStorage.setItem("USER-REFERED-BY", account_refered_by);
                localStorage.setItem("PROJECT-NAME", selected_game);
                localStorage.setItem("PLATFORM", input_platform_type.value);
                localStorage.setItem("SELECTED-PAGE", "win");
                window.open("play.php","_self");

            } else {
                showToast('Mobile Number OR Password is incorrect!');
            }

            dismissLoadingDialog();
        } catch (error) {
            dismissLoadingDialog();
        }
    }

    USER_MOBILE_NUM = input_mobile_num.value;
    USER_PASSWORD = input_password.value;
    USER_MOBILE_NUM = USER_MOBILE_NUM.slice(3);

    if (USER_MOBILE_NUM != "" && USER_PASSWORD != "") {

        if (!/^[0-9]+$/.test(USER_MOBILE_NUM) || USER_MOBILE_NUM.length != 10) {
            showToast('Invalid Mobile Number!');
        } else if (apiTargetURL != "") {
            showLoadingDialog();
            requestFile(USER_MOBILE_NUM, USER_PASSWORD);
        }
    } else {
        showToast('Invalid Mobile Num OR Password!');
    }
}

}