<!DOCTYPE html>
<html ⚡ lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, minimum-scale=1, initial-scale=1">
    <title><?php echo $title; ?></title>
    <meta name="description"
        content="<?php echo $description; ?>" />
    <meta name="robots" content="index,follow" />
    <link href="https://iili.io/2Qkgd3G.png" rel="shortcut icon" type="image/x-icon" />
    <link rel="canonical" href="<?php echo $domamp ?>" />
    <meta property="og:url" content="<?php echo $domamp ?>" />
    <meta property="og:site_name" content="qqbet4d" />
    <meta property="og:image:alt" content="qqbet4d" />
    <meta property="og:image" content="<?php echo $link_banner ?>" />
    <!-- AMP Requirements -->
    <style amp-boilerplate>body{-webkit-animation:-amp-start 8s steps(1,end) 0s 1 normal both;-moz-animation:-amp-start 8s steps(1,end) 0s 1 normal both;-ms-animation:-amp-start 8s steps(1,end) 0s 1 normal both;animation:-amp-start 8s steps(1,end) 0s 1 normal both}@-webkit-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@-moz-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@-ms-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@-o-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}</style><noscript><style amp-boilerplate>body{-webkit-animation:none;-moz-animation:none;-ms-animation:none;animation:none}</style></noscript>
    <script async src="https://cdn.ampproject.org/v0.js"></script>
    
    <style amp-custom>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Arial', sans-serif;
            -webkit-tap-highlight-color: transparent;
        }

        body {
            min-height: 100vh;
            background: #000000
                        url('<?php echo $link_lpbg ?>') center/cover fixed;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 15px;
        }

        .container {
            backdrop-filter: blur(10px);
            padding: 1.5rem;
            width: 100%;
            max-width: 500px;
            text-align: center;
            box-shadow: 0 4px 20px rgba(61, 0, 0, 0.2);
        }

        .logo {
            width: 130px;
            height: auto;
            margin: 0 auto 1rem;
            display: block;
        }

        .banner-container {
            position: relative;
            width: 100%;
            max-width: 500px;
            margin: 1rem auto;
            border-radius: 10px;
            overflow: hidden;
            aspect-ratio: 1/1;
        }

        .banner {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .banner-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 40%;
            height: 100%;
            background: linear-gradient(
                90deg,
                rgba(255,255,255,0) 0%,
                rgba(255,255,255,0.15) 50%,
                rgba(255,255,255,0) 100%
            );
            transform: skewX(-25deg);
            animation: sweep 5s ease-in-out infinite;
            will-change: transform;
            pointer-events: none;
            z-index: 2;
        }

        @keyframes sweep {
            0% { transform: translateX(-100%) skewX(-25deg); }
            100% { transform: translateX(500%) skewX(-25deg); }
        }

        .button-group {
            display: grid;
            gap: 12px;
            margin-top: 1.5rem;
        }

        .btn {
            padding: 12px 24px;
            border-radius: 10px;
            font-size: 1rem;
            font-weight: 600;
            transition: transform 0.2s ease;
            text-decoration: none;
            border: none;
            width: 100%;
            display: block;
        }

        .login-btn { color: rgb(33 31 29); background: #ffffff; box-shadow: 0 0 30px #d16601; }
        .register-btn { color: rgb(255, 255, 255); background: #000000; }

        .welcome {
            max-width: 300px;
            margin: 0 auto 1rem;
            text-align: center;
        }

        .welcome h1 {
            font-size: 14px;
            color: #fff;
            overflow: hidden;
            border-right: .15em solid #fbf4a0;
            white-space: nowrap;
            letter-spacing: .05em;
            animation: typing 2.5s steps(30, end), blink-caret 0.75s step-end infinite;
            margin: 0 auto;
        }

        @media (max-width: 480px) {
            .container {
                padding: 1rem;
                border-radius: 12px;
            }
            
            .logo {
                width: 110px;
            }
            
            .btn {
                padding: 10px 20px;
                font-size: 0.95rem;
            }
            
            .welcome h1 {
                font-size: 12px;
                white-space: normal;
                animation: none;
                border-right: none;
                line-height: 1.4;
            }
            
            .banner-container::before {
                animation-duration: 2.5s;
            }
        }

        @keyframes typing {
            from { width: 0 }
            to { width: 100% }
        }
        
        @keyframes blink-caret {
            from, to { border-color: transparent }
            50% { border-color: #fbf4a0 }
        }
    </style>
</head>
<body>
    <div class="container">
        <amp-img src="https://brdsg.com/img/1200/bsob0d3ebsocindln8_2/CWlHNdxuxzTrh9vCWlb1JVPbrQpCHmQYOb7VGtTvKhJA.png"
                 width="200"
                 height="60"
                 layout="responsive"
                 alt="Logo"
                 class="logo">
        </amp-img>
        
        <div class="welcome">
            <h1><?php echo $Text_type ?></h1>
        </div>
        
        <div class="banner-container">
            <amp-img src="<?php echo $link_banner ?>"
                     width="500"
                     height="500"
                     layout="responsive"
                     alt="Banner"
                     class="banner">
            </amp-img>
        </div>
        
        <div class="button-group">
            <a href="https://rdrnwl.net/qqbet4d" class="btn login-btn" role="button">MASUK</a>
            <a href="https://rdrnwl.net/qqbet4d" class="btn register-btn" role="button">DAFTAR</a>
        </div>
    </div>
</body>
</html>