vinAngular.requires.push("ngAudio");

vinAngular.directive('ngVinAudio', function () {
	return {
		scope: {
			src: '@',
			title: '@'
		},
		restrict: 'A',
		templateUrl: '/Global/JS/angular/vin.audio.template.html',
		link: function (scope, element, attrs) {
			var attName = "ng-vin-audio";
			scope.element = element[0];
			if (scope.element.hasAttributes() && scope.element.hasAttribute(attName) && (scope.element.getAttribute(attName) == 'false' || scope.element.getAttribute(attName) == '')) {
				scope.element.setAttribute(attName, 'true');
				//debugger;
			}
		}
	};
});

vinAngular.controller("audioVin", ['$scope', '$element', 'ngAudio',
	function ($scope, $element, ngAudio) {

		$scope.audio = ngAudio.load($scope.src);

		$scope.progStyle = {
			'width': $scope.audio.progress * 100 + '%'
		};

		$scope.playSound = function () {
			$scope.audio.play();
		};

		$scope.isPaused = function () {
			var pause = true;
			try {
				pause = $scope.audio.audio.paused;
			} catch (ex) {
				pause = true;
			}
			return pause;
		};

		$scope.playToggle = function () {
			if ($scope.isPaused()) {
				$scope.audio.play();
			} else {
				$scope.audio.pause();
			}

		};

		$scope.jumpAudio = function (jumpTime) {
			$scope.audio.currentTime += jumpTime;
		};

		$scope.pauseSound = function () {
			$scope.audio.pause();
		};

		$scope.progressClick = function (clickEvent) {
			clickEvent.stopPropagation();
			clickEvent.cancelBubble = true;
			//console.log( clickEvent.target.offsetWidth - clickEvent.offsetX);
			$scope.audio.progress = clickEvent.offsetX / clickEvent.currentTarget.offsetWidth;

		};

		$scope.progressMouseDown = function (clickEvent) {
			$scope.audio.pause();
			$scope.mouseDown = true;
			clickEvent.cancelBubble = true;
			//console.log( clickEvent.target.offsetWidth - clickEvent.offsetX);
			$scope.audio.progress = clickEvent.offsetX / clickEvent.currentTarget.offsetWidth;

		};

		$scope.progressMouseUp = function (clickEvent) {
			clickEvent.stopPropagation();
			clickEvent.cancelBubble = true;
			//console.log( clickEvent.target.offsetWidth - clickEvent.offsetX);
			$scope.audio.progress = clickEvent.offsetX / clickEvent.currentTarget.offsetWidth;
			$scope.audio.play();
			$scope.mouseDown = false;
		};

		$scope.progressMouseMove = function (clickEvent) {

			clickEvent.cancelBubble = true;
			if ($scope.mouseDown) {

				$scope.audio.progress = clickEvent.offsetX / clickEvent.currentTarget.offsetWidth;
			}

		};

		$scope.setTime = function () {
			$scope.audio.currentTime = 100;
			$scope.progStyle = {
				'width': $scope.audio.progress * 100 + '%'
			};
		}

		//$scope.playStateIconn = {'background-image' : "url('/global/js/angular/icon_" + ($scope.audio.audio.paused ? "play" : "pause" ) + ".png')"};

		$scope.playStateIcon = function () {
			if ($scope.isPaused()) {
				return {
					'background-image': "url('../ext_iframe/global/js/angular/icon_play.png')"
				}

			} else {
				return {
					'background-image': "url('../ext_iframe/global/js/angular/icon_pause.png')"
				}
			}
		}
	}
]);

try {

	function InitializeAngularAudioElements() {
		if (typeof (jQuery) == 'undefined' || typeof ($j) == 'undefined') {
			console.log('jQuery is not loaded on this page and audio player will not work')
			return;
		}
		var getAngular = $j("div[ng-vin-audio]");
		for (var i = 0; i < getAngular.length; i++) {
			if (getAngular[i].getAttribute("ng-vin-audio") != "true") {
				angular.element(document.body).injector().invoke([
					"$compile", "$rootScope",
					function ($compile, $rootScope) {
						$compile(getAngular[i])($rootScope);
					}
				]);
			}
		}
	}

	//cant use $j or jQuery because it is not included on all pages
	if (document.readyState != 'loading') InitializeAngularAudioElements();
	else document.addEventListener('DOMContentLoaded', InitializeAngularAudioElements);

} catch (e) {
	console.error('error loading audio player:', e);
}